<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'start_date', 'end_date');

    public function location()
    {
        return $this->belongsTo('App\Model\Location');
    }

    public function customer()
    {
        return $this->belongsTo('App\Model\Customer');
    }

    public function tracks()
    {
        return $this->hasMany('App\Model\Place');
    }

}